package timezone

import (
	"time"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/storage/station"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/storage/timezone"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
)

type TimeZoneProvider interface {
	GetTimeZoneByStationID(stationID int64) *time.Location
}

type TimeZoneUtil interface {
	timezone.TimeZoneStorage
	GetTimeZoneByStationID(stationID int64) *time.Location
}

func NewTimeZoneUtil(timeZoneStorage timezone.TimeZoneStorage, stations station.StationStorage) TimeZoneUtil {
	return &timeZoneUtilImpl{TimeZoneStorage: timeZoneStorage, stations: stations}
}

func NewTimeZoneProvider(timeZoneStorage timezone.TimeZoneStorage, stations station.StationStorage) TimeZoneProvider {
	return NewTimeZoneUtil(timeZoneStorage, stations)
}

type timeZoneUtilImpl struct {
	timezone.TimeZoneStorage
	stations station.StationStorage
}

func (s *timeZoneUtilImpl) GetTimeZoneByStationID(stationID int64) *time.Location {
	Station, hasStation := s.stations.ByID(stationID)
	if !hasStation {
		logger.Logger().Error("unable to find station", log.Int64("station id", stationID))
		return nil
	}
	return s.GetTimeZone(Station.Station)
}
