package flight

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type ForceMode int8

const (
	AsScheduled ForceMode = 1 + iota
	ForceBan
	Disabled
	end
)

func (d ForceMode) IsValid() bool {
	return d > 0 && d < end
}

func (d ForceMode) String() string {
	switch d {
	case AsScheduled:
		return "AS_SCHEDULED"
	case ForceBan:
		return "FORCE_BAN"
	case Disabled:
		return "DISABLED"
	default:
		return fmt.Sprintf("Unknown force mode (%d)", d)
	}
}

func FromString(d string) (ForceMode, error) {
	d = strings.ToUpper(d)
	switch d {
	case "AS_SCHEDULED":
		return AsScheduled, nil
	case "FORCE_BAN":
		return ForceBan, nil
	case "DISABLED":
		return Disabled, nil
	default:
		return 0, xerrors.Errorf("unknown force mode (%s)", d)
	}
}
