package status

import "a.yandex-team.ru/travel/proto/shared_flights/snapshots"

type stationStatusSourcePK struct {
	StationID int64
	SourceID  int64
}

type StationStatusSourceStorage struct {
	trusted map[stationStatusSourcePK]bool
}

func NewStationStatusSourceStorage() *StationStatusSourceStorage {
	return &StationStatusSourceStorage{trusted: make(map[stationStatusSourcePK]bool)}
}

func (s *StationStatusSourceStorage) PutStationStatusSourceMapping(sss *snapshots.TStationStatusSource) {
	s.trusted[stationStatusSourcePK{sss.StationID, sss.StatusSourceID}] = sss.Trusted
}

func (s *StationStatusSourceStorage) IsTrusted(stationID int64, statusSourceID int64) bool {
	if trusted, known := s.trusted[stationStatusSourcePK{stationID, statusSourceID}]; known {
		return trusted
	}
	return false
}
