package transportmodel

import (
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/strutil"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type TransportModelStorage interface {
	PutTransportModel(*rasp.TTransportModel)
	GetByID(int32) *rasp.TTransportModel
	GetByCode(string) *rasp.TTransportModel
	GetCode(int32) string
}

type transportModelStorageImpl struct {
	transportModelsByID   map[int32]*rasp.TTransportModel
	transportModelsByCode map[string]*rasp.TTransportModel
}

func NewTransportModelStorage() TransportModelStorage {
	return &transportModelStorageImpl{
		make(map[int32]*rasp.TTransportModel),
		make(map[string]*rasp.TTransportModel),
	}
}

func (s *transportModelStorageImpl) PutTransportModel(transportModel *rasp.TTransportModel) {
	s.transportModelsByID[transportModel.Id] = transportModel
	s.transportModelsByCode[transportModel.Code] = transportModel
	s.transportModelsByCode[transportModel.CodeEn] = transportModel
}

func (s *transportModelStorageImpl) GetByID(id int32) *rasp.TTransportModel {
	value, hasValue := s.transportModelsByID[id]
	if !hasValue {
		return nil
	}
	return value
}

func (s *transportModelStorageImpl) GetByCode(code string) *rasp.TTransportModel {
	value, hasValue := s.transportModelsByCode[code]
	if !hasValue {
		return nil
	}
	return value
}

func (s *transportModelStorageImpl) GetCode(id int32) string {
	value, hasValue := s.transportModelsByID[id]
	if !hasValue {
		return ""
	}
	return strutil.Coalesce(value.CodeEn, value.Code)
}
