package utils

import (
	"sort"
)

type StringList []string

type void struct{}

var empty = void{}

func UpdateMapToSortedStringList(flightMap map[uint64]StringList, p2pKey uint64, flightKey string) {
	flightKeys, ok := flightMap[p2pKey]
	if !ok {
		flightMap[p2pKey] = []string{flightKey}
	} else {
		flightMap[p2pKey] = UpdateSortedStringList(flightKeys, flightKey)
	}
}

func UpdateSortedStringList(list StringList, newKey string) StringList {
	pos := sort.SearchStrings(list, newKey)
	if pos >= len(list) {
		list = append(list, newKey)
	} else if list[pos] != newKey {
		list = append(list, "")
		copy(list[pos+1:], list[pos:])
		list[pos] = newKey
	}
	return list
}

func MergeLists(list1, list2 StringList) map[string]void {
	tempMap := make(map[string]void)
	for _, elem1 := range list1 {
		tempMap[elem1] = empty
	}
	for _, elem2 := range list2 {
		tempMap[elem2] = empty
	}
	return tempMap
}

type StringListMap map[string]StringList

func NewStringListMap() StringListMap {
	return make(map[string]StringList)
}

func (m StringListMap) Put(key, value string) {
	currentValue, hasValue := m[key]
	if !hasValue {
		m[key] = StringList{value}
	} else {
		for _, valueElem := range currentValue {
			if valueElem == value {
				return
			}
		}
		currentValue = append(currentValue, value)
		m[key] = currentValue
	}
}

func (m StringListMap) GetCount(key string) int {
	currentValue, hasValue := m[key]
	if !hasValue {
		return 0
	}
	return len(currentValue)
}
