package utils

import (
	"strings"
)

func NumericFlightNumber(flightNumber string) int32 {
	flightRune := []rune(flightNumber)
	// do not process long strings to avoid overflowing int32 resulting value
	if len(flightRune) == 0 || len(flightRune) > 7 {
		return 0
	}
	result := int32(0)
	for _, r := range flightRune {
		if r >= '0' && r <= '9' {
			result = result*10 + (r - '0')
		}
	}
	return result
}

func TrimZeroesFromFlightNumber(text string) string {
	result := strings.TrimLeft(text, "0")
	if result != "" {
		return result
	}
	return "0"
}
