package structs

import (
	"a.yandex-team.ru/travel/proto/shared_flights/snapshots"
)

type FlightMergeRule struct {
	ID                    int32  `json:"ID,omitempty"`
	OperatingCarrier      int32  `json:"OperatingCarrier,omitempty"`
	OperatingFlightRegexp string `json:"OperatingFlightRegexp,omitempty"`
	MarketingCarrier      int32  `json:"MarketingCarrier,omitempty"`
	MarketingFlightRegexp string `json:"MarketingFlightRegexp,omitempty"`
	ExcludedCarrier       int32  `json:"ExcludedCarrier,omitempty"`
	ShouldMerge           bool   `json:"ShouldMerge"`
	IsActive              bool   `json:"IsActive"`
	UpdatedAtUTC          string `json:"UpdatedAtUtc,omitempty"`
	Comment               string `json:"Comment,omitempty"`
}

func FlightMergeRuleFromProto(source *snapshots.TFlightMergeRule) FlightMergeRule {
	return FlightMergeRule{
		ID:                    source.Id,
		OperatingCarrier:      source.OperatingCarrier,
		OperatingFlightRegexp: source.OperatingFlightRegexp,
		MarketingCarrier:      source.MarketingCarrier,
		MarketingFlightRegexp: source.MarketingFlightRegexp,
		ExcludedCarrier:       source.ExcludedCarrier,
		ShouldMerge:           source.ShouldMerge,
		IsActive:              source.IsActive,
		UpdatedAtUTC:          source.UpdatedAt,
		Comment:               source.Comment,
	}
}
