package structs

import (
	"fmt"

	"a.yandex-team.ru/travel/proto/shared_flights/ssim"
)

// FlightPattern is based on TFlightPattern protobuf
type FlightPattern struct {
	ID                       int32  `json:"Id,omitempty"`
	FlightBaseID             int32  `json:"FlightBaseId,omitempty"`
	MarketingCarrier         int32  `json:"MarketingCarrier,omitempty"`
	MarketingCarrierCode     string `json:"MarketingCarrierCode,omitempty"`
	MarketingFlightNumber    string `json:"MarketingFlightNumber,omitempty"`
	LegNumber                int32  `json:"LegNumber,omitempty"`
	OperatingFromDate        string `json:"OperatingFromDate,omitempty"`
	OperatingUntilDate       string `json:"OperatingUntilDate,omitempty"`
	OperatingOnDays          int32  `json:"OperatingOnDays,omitempty"`
	IsCodeshare              bool   `json:"IsCodeshare,omitempty"`
	IsDop                    bool   `json:"IsDop,omitempty"`
	ArrivalDayShift          int32  `json:"ArrivalDayShift,omitempty"`
	DepartureDayShift        int32  `json:"DepartureDayShift,omitempty"`
	FlightDayShift           int32  `json:"FlightDayShift,omitempty"`
	DesignatedCarrier        int32  `json:"DesignatedCarrier,omitempty"`
	CorrectedCarrier         int32  `json:"CorrectedCarrier,omitempty"`
	FilingCarrier            int32  `json:"FilingCarrier,omitempty"`
	FilingCarrierCode        string `json:"FilingCarrierCode,omitempty"`
	OperatingFlightPatternID int32  `json:"OperatingFlightPatternId,omitempty"`
	IsHalfFlight             bool   `json:"IsHalfFlight,omitempty"`
}

func (fp FlightPattern) String() string {
	return fmt.Sprintf("%#v", fp)
}

func (fp FlightPattern) TitleCarrierCode() string {
	if fp.FilingCarrierCode != "" {
		return fp.FilingCarrierCode
	}
	return fp.MarketingCarrierCode
}

func (fp FlightPattern) CorrectedCarrierID() int32 {
	if fp.CorrectedCarrier != 0 {
		return fp.CorrectedCarrier
	}
	return fp.MarketingCarrier
}

func (fp FlightPattern) FlightTitle() string {
	return fmt.Sprintf("%s %s", fp.TitleCarrierCode(), fp.MarketingFlightNumber)
}

func FlightPatternFromProto(source *ssim.TFlightPattern, carrierResolver carrierCodeResolver) FlightPattern {
	return FlightPattern{
		ID:                    source.Id,
		FlightBaseID:          source.FlightId,
		MarketingCarrier:      source.MarketingCarrier,
		MarketingCarrierCode:  carrierResolver(source.MarketingCarrier),
		MarketingFlightNumber: source.MarketingFlightNumber,
		LegNumber:             source.LegSeqNumber,
		OperatingFromDate:     source.OperatingFromDate,
		OperatingUntilDate:    source.OperatingUntilDate,
		OperatingOnDays:       source.OperatingOnDays,
		IsCodeshare:           source.IsCodeshare,
		IsDop:                 source.IsDop,
		ArrivalDayShift:       source.ArrivalDayShift,
		DepartureDayShift:     source.DepartureDayShift,
		FlightDayShift:        source.FlightDayShift,
		DesignatedCarrier:     source.DesignatedCarrier,
		CorrectedCarrier:      source.CorrectedCarrier,
		FilingCarrier:         source.FilingCarrier,
		FilingCarrierCode:     carrierResolver(source.FilingCarrier),
		IsHalfFlight:          source.IsHalfFlight,
	}
}
