import argparse


def parse_args(args_list=None):
    parser = argparse.ArgumentParser()
    parser.add_argument('--noamadeus', required=False, action='store_false')
    parser.add_argument('--forceamadeus', required=False, action='store_true', default=False,
                        help='Parse Amadeus even if already imported')
    parser.add_argument('--nosirena', required=False, action='store_false')
    parser.add_argument('--forcesirena', required=False, action='store_true', default=False,
                        help='Force sirena parser even if already imported')
    parser.add_argument('--nostoppoints', required=False, action='store_false')
    parser.add_argument('--notransportmodels', required=False, action='store_false')
    parser.add_argument('--noraspdata', required=False, action='store_false',
                        help='Don\'t push rasp data to database')
    parser.add_argument('--noemail', required=False, action='store_false',
                        help='Don\'t send notifications about missing or extra data')
    parser.add_argument('--forceemail', required=False, action='store_true', default=False,
                        help='Send email even if we did not import any new schedule data')
    parser.add_argument('--echosql', required=False, action='store_true', default=False,
                        help='Echo sql statements')
    parser.add_argument('--force', required=False, default=False, action='store_true',
                        help='Ignore database lock')
    parser.add_argument('--nodaemon', required=False, action='store_false')
    parser.add_argument('--transportmodelsfile', required=False)
    if args_list:
        return parser.parse_args(args_list)
    return parser.parse_args()
