# coding: utf8
from __future__ import unicode_literals

from enum import Enum


class State(Enum):
    starting = 'starting'
    available = 'available'
    busy = 'busy'
    broken = 'broken'


class AppState(object):

    def __init__(self):
        self._state = State.starting
        self._message = 'App is starting'

    @property
    def state(self):
        return self._state

    @state.setter
    def state(self, value):
        self._state = value

    @property
    def message(self):
        return self._message

    @message.setter
    def message(self, value):
        self._message = value
