#Diff-Builder

##Что это?
Компонента сервиса `shared-flights`, которая собирает бинарные снепшоты (или дифы),
которые потом загружает `api` в память. `Diff-builder` складывает
снепшоты в mds после формирования

##Построение снепшотов
Снепшотом мы называем данные о регулярных расписаниях авиарейсов за 30 прошлых и 330 будущих дней, с сопутствующими справочниками.
Снепшоты обновляются обычно раз в сутки.
После переезда проекта в деплой, снепшоты строятся в сендбоксе - ищи таски с типом AVIA_SHARED_FLIGHTS_DIFF_BUILDER_TASK, чтобы узнать параметры запуска:

https://sandbox.yandex-team.ru/tasks?children=true&type=AVIA_SHARED_FLIGHTS_DIFF_BUILDER_TASK&limit=20&created=14_days

##Построение дельт
Дельтами мы называем данные о статусах рейсов за 30 прошлых и 3 будущих дня, с сопутствующими справочниками.
Дельты обновляются обычно раз в пару минут.
Компонента проекта в деплое занимается исключительно построением дельт.

##Запустить локально
Список переменных можно найти тут - ./tools/samples/dev.env

Если список переменных в ./dev.env устарел, его можно украсть с тестовой машинки вот отсюда:
https://deploy.yandex-team.ru/stages/avia-shared-flights-testing/status/diffbuilder

```shell
cp ./tools/samples/dev.env ./dev.env
ya make --yt-store --checkout ./app
./app/diff_builder --nodaemon --force True
```

Параметр --nodaemon заставляет приложение построить дельту однократно и завершить работу.
Без этого параметра приложение будет строить дельты до тех пор, пока не будет завершено принудительно.

Параметр --force=True позволяет приложению игнорировать блокировки в базе данных на выполнение операции построения дельты
(запись с ключом BUILD_DELTA в таблице db_lock). Без этого параметра, если рабочий инстанс выполняет построение дельты прямо сейчас (т.е. почти всегда)
программа не сможет получить лок и завершится с ошибкой.
