from travel.avia.library.python.boto3_entities import S3ClientProto

import boto3
from botocore.client import Config


def make_mds_client(key_id: str, key_secret: str) -> S3ClientProto:
    session = boto3.session.Session(
        aws_access_key_id=key_id,
        aws_secret_access_key=key_secret,
    )

    config = Config(connect_timeout=1000, read_timeout=5000, retries={'max_attempts': 2})

    return session.client(
        service_name='s3',
        endpoint_url='https://s3.mds.yandex.net',
        config=config,
    )
