# coding: utf8
from __future__ import unicode_literals

import logging

import tornado
from tornado.web import RequestHandler
from raven.contrib.tornado import SentryMixin

logger = logging.getLogger(__name__)


class BaseHandler(SentryMixin, RequestHandler):
    def __init__(self, application, request, **kwargs):
        super(BaseHandler, self).__init__(application, request, **kwargs)

    def initialize(self, state):
        self._state = state

    @property
    def state(self):
        return self._state

    def prepare(self):
        pass


class PingHandler(BaseHandler):
    def get(self):
        self.write('OK')


class StateHandler(BaseHandler):
    def __init__(self, application, request, **kwargs):
        super(StateHandler, self).__init__(application, request, **kwargs)

    def get(self):
        self.set_header('Content-Type', 'text/plain')
        self.write('Tornado version: {}\n'.format(tornado.version))
        self.write('State: {}\n'.format(self.state.state))
        self.write('Message: {}\n'.format(self.state.message))
