# coding: utf8
from __future__ import unicode_literals

from enum import Enum


class State(Enum):
    starting = 'starting'
    available = 'available'
    busy = 'busy'
    broken = 'broken'


class AppState(object):
    def __init__(self):
        self._state = State.starting
        self._message = 'App is starting'

    @property
    def state(self) -> State:
        return self._state

    @state.setter
    def state(self, value: State) -> None:
        self._state = value

    @property
    def message(self) -> str:
        return self._message

    @message.setter
    def message(self, value: str) -> None:
        self._message = value
