# coding=utf-8
from travel.library.python.dicts.file_util import write_binary_string as write_binary_string_with_size_limit


CYRILLIC_TO_LATIN = str.maketrans('АВЕКМНОРСТ', 'ABEKMHOPCT')

# Max size of a single protobuf record.
# Shall not exceed MaxProtoSize value in api, so the diff-builder would fail first, protecting the api
MAX_PROTO_SIZE = 100000


def convert_to_latin(text: str) -> str:
    return text.translate(CYRILLIC_TO_LATIN)


def get_bucket_key(carrier: int, flight_number: str, leg_number: int) -> str:
    return '{}.{}.{}'.format(carrier, flight_number, leg_number)


def ensure_string(text: str) -> str:
    return text or ''


def write_binary_string(output_file, binary_string):
    write_binary_string_with_size_limit(output_file, binary_string, MAX_PROTO_SIZE)
