package direction

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type Direction int8

const (
	ARRIVAL Direction = 1 + iota
	DEPARTURE
	end
)

func (d Direction) IsValid() bool {
	return d > 0 && d < end
}

func (d Direction) String() string {
	switch d {
	case ARRIVAL:
		return "arrival"
	case DEPARTURE:
		return "departure"
	default:
		return fmt.Sprintf("Unknown direction (%d)", d)
	}
}

func FromString(d string) (Direction, error) {
	d = strings.ToLower(d)
	switch d {
	case "departure":
		return DEPARTURE, nil
	case "arrival":
		return ARRIVAL, nil
	default:
		return 0, xerrors.Errorf("unknown direction (%s)", d)
	}
}
