package dtutil

import (
	"time"

	"a.yandex-team.ru/library/go/core/xerrors"
)

func init() {
	DateCache = generateDateCache()
}

// Cache for fast iteration over dates
var DateCache tDateCache

type tDateCache struct {
	tDateContinuum
	tIntDateToDateNodeMap
	tStringDateToDateNodeMap
}

type tDateContinuum []tDate
type tIntDateToDateNodeMap map[IntDate]int
type tStringDateToDateNodeMap map[StringDate]int

type tDate struct {
	date    IntDate
	weekday time.Weekday
}

func (dc *tDateCache) IndexOfStringDate(date StringDate) (index int, ok bool) {
	index, ok = dc.tStringDateToDateNodeMap[date]
	return index, ok
}

// IndexOfStringDateP is a panic version of IndexOfStringDate
func (dc *tDateCache) IndexOfStringDateP(date StringDate) int {
	index, ok := dc.tStringDateToDateNodeMap[date]
	if !ok {
		panic(xerrors.Errorf("date %v not in index", date))
	}
	return index
}

func (dc *tDateCache) IndexOfIntDate(intDate IntDate) (index int, ok bool) {
	index, ok = dc.tIntDateToDateNodeMap[intDate]
	return index, ok
}

// IndexOfIntDateP is a panic version of IndexOfIntDate
func (dc *tDateCache) IndexOfIntDateP(intDate IntDate) int {
	index, ok := dc.tIntDateToDateNodeMap[intDate]
	if !ok {
		panic(xerrors.Errorf("date %v not in index", intDate))
	}
	return index
}

func (dc *tDateCache) Date(index int) IntDate {
	return dc.tDateContinuum[index].date
}

func (dc *tDateCache) WeekDay(index int) time.Weekday {
	return dc.tDateContinuum[index].weekday
}

// TODO(mikhailche): move me to dtutil with iterDate
func generateDateCache() tDateCache {
	// Must be the same or earlier than dtutil.MinDate
	startDate := time.Date(2010, 1, 1, 0, 0, 0, 0, time.UTC)
	// Must be the same or later than dtutil.MaxDate + 9 days (u-jeen: I don't know why 9)
	stopDate := time.Date(2099, 2, 1, 0, 0, 0, 0, time.UTC)

	dateCache := tDateCache{
		make(tDateContinuum, 0, 366*90),
		make(map[IntDate]int),
		make(map[StringDate]int),
	}

	i := 0
	for date := startDate; date.Before(stopDate); date = date.AddDate(0, 0, 1) {
		intDate := DateToInt(date)
		weekday := date.Weekday()
		dateCache.tDateContinuum = append(dateCache.tDateContinuum, tDate{date: intDate, weekday: weekday})
		dateCache.tIntDateToDateNodeMap[intDate] = i

		dateCache.tStringDateToDateNodeMap[intDate.StringDate()] = i
		dateCache.tStringDateToDateNodeMap[intDate.StringDateDashed()] = i
		i++
	}
	return dateCache
}
