package dtutil

type StringDateInterval struct {
	From StringDate
	To   StringDate
}

func NewStringDateInterval(from, to string) StringDateInterval {
	return StringDateInterval{
		From: StringDate(from),
		To:   StringDate(to),
	}
}

func Intersect(operating, banned StringDateInterval) []StringDateInterval {
	unprocessed := make([]StringDateInterval, 0)
	unprocessed = append(unprocessed, operating)

	result := make([]StringDateInterval, 0)

	operatingFrom, ok := DateCache.IndexOfStringDate(operating.From)
	if !ok {
		return unprocessed
	}

	operatingTo, ok := DateCache.IndexOfStringDate(operating.To)
	if !ok {
		return unprocessed
	}

	bannedFrom, ok := DateCache.IndexOfStringDate(banned.From)
	if !ok {
		return unprocessed
	}

	bannedTo, ok := DateCache.IndexOfStringDate(banned.To)
	if !ok {
		return unprocessed
	}

	// Ban range does not intersect with the operating range
	if operatingFrom > bannedTo || operatingTo < bannedFrom {
		return unprocessed
	}

	// Ban range fully covers the operating range
	if bannedFrom <= operatingFrom && bannedTo >= operatingTo {
		return result
	}

	// Ban range is in the middle of the operating range
	if bannedFrom > operatingFrom && bannedTo < operatingTo {
		interval1 := StringDateInterval{
			From: DateCache.Date(operatingFrom).StringDateDashed(),
			To:   DateCache.Date(bannedFrom - 1).StringDateDashed(),
		}
		interval2 := StringDateInterval{
			From: DateCache.Date(bannedTo + 1).StringDateDashed(),
			To:   DateCache.Date(operatingTo).StringDateDashed(),
		}
		result = append(result, interval1)
		result = append(result, interval2)
		return result
	}

	// Ban range is on the left side of the operating range
	if bannedFrom <= operatingFrom {
		interval := StringDateInterval{
			From: DateCache.Date(bannedTo + 1).StringDateDashed(),
			To:   DateCache.Date(operatingTo).StringDateDashed(),
		}
		result = append(result, interval)
		return result
	}

	// Ban range is on the right side of the operating range
	if bannedTo >= operatingTo {
		interval := StringDateInterval{
			From: DateCache.Date(operatingFrom).StringDateDashed(),
			To:   DateCache.Date(bannedFrom - 1).StringDateDashed(),
		}
		result = append(result, interval)
		return result
	}

	// this never happens, all the possibilities are processed above
	return result
}
