package dtutil

import (
	"time"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
)

type DateWithWeekday struct {
	Index   int
	IntDate IntDate
	Weekday time.Weekday
}

func IterDate(from, until IntDate) []DateWithWeekday {
	defer func() {
		if err := recover(); err != nil {
			logger.Logger().Error("IterDate panic", log.Reflect("err", err))
		}
	}()

	if until < from {
		until, from = from, until
	}

	fromIdx := DateCache.IndexOfIntDateP(from)
	untilIdx := DateCache.IndexOfIntDateP(until)

	var dates []DateWithWeekday
	for date := fromIdx; date <= untilIdx; date++ {
		dates = append(
			dates,
			DateWithWeekday{
				date,
				DateCache.Date(date),
				DateCache.WeekDay(date),
			},
		)
	}
	return dates
}
