package dtutil

import (
	"time"
)

func LocalTime(dateIndex int, scheduledTime int32, tz *time.Location) time.Time {
	return IntToTime(
		DateCache.Date(dateIndex),
		IntTime(scheduledTime),
		tz,
	)
}

func FormatWithTz(dateIndex int, scheduledTime int32, tz *time.Location) string {
	return LocalTime(dateIndex, scheduledTime, tz).Format(time.RFC3339)
}
