package dtutil

import "time"

type OperatingDays int32

func (od OperatingDays) OperatesOn(dow time.Weekday) bool {
	operatingOnDays := int32(od)
	for operatingOnDays > 0 {
		currentDay := operatingOnDays % 10
		if 7 >= currentDay && currentDay >= 1 && int(dow) == int(currentDay%7) {
			return true
		}
		operatingOnDays /= 10
	}
	return false
}

func (od OperatingDays) ShiftDays(days int) OperatingDays {
	var opdays uint8

	for od > 0 {
		currentDay := od % 10
		currentDay %= 7
		shiftedDay := currentDay + OperatingDays(days)
		for shiftedDay < 0 {
			shiftedDay += 7
		}
		shiftedDay %= 7
		opdays |= 1 << shiftedDay
		od /= 10
	}

	return FromBitmask(opdays)
}

func (od OperatingDays) bitmask() uint8 {
	var mask uint8
	for od > 0 {
		day := (od % 10) % 7
		mask |= 1 << day
		od /= 10
	}
	return mask
}

func FromBitmask(mask uint8) OperatingDays {
	var newopdays OperatingDays
	for i := 1; i <= 7; i++ {
		if mask&(1<<(i%7)) > 0 {
			newopdays = newopdays*10 + OperatingDays(i)
		}
	}
	return newopdays
}

func (od OperatingDays) Intersect(od2 OperatingDays) OperatingDays {
	return FromBitmask(od.bitmask() & od2.bitmask())
}

func (od OperatingDays) Union(od2 OperatingDays) OperatingDays {
	return FromBitmask(od.bitmask() | od2.bitmask())
}

func (od OperatingDays) AddDay(dow time.Weekday) OperatingDays {
	return FromBitmask(od.bitmask() | 1<<(int(dow)%7))
}

func OperatesOn(pattern int32, dow time.Weekday) bool {
	return OperatingDays(pattern).OperatesOn(dow)
}

func (od OperatingDays) ReadableString() string {
	result := []rune(".......")
	operatingOnDays := int32(od)
	for operatingOnDays > 0 {
		currentDay := operatingOnDays % 10
		if currentDay > 0 && currentDay <= 7 {
			result[currentDay-1] = '0' + currentDay
		}
		operatingOnDays /= 10
	}
	return string(result)
}
