package ioutil

import (
	"io"
	"strconv"
	"time"

	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
)

type WriterWithProgress struct {
	Writer        io.Writer
	totalN        int
	lastN         int
	lastPrintedAt time.Time
}

func (w *WriterWithProgress) Write(p []byte) (n int, err error) {
	n, err = w.Writer.Write(p)
	w.totalN += n
	if w.totalN > w.lastN || time.Since(w.lastPrintedAt) > 10*time.Second {
		logger.Logger().Infof("Wrote %s", formatBytes(w.totalN))
		w.lastN = int(float64(w.totalN) * 2.0)
		w.lastPrintedAt = time.Now()
	}
	return
}

func formatBytes(n int) string {
	const twoPowTen = 1024
	if n < twoPowTen {
		return strconv.Itoa(n) + " b"
	} else if n < (twoPowTen * twoPowTen) {
		return strconv.Itoa(n/twoPowTen) + " kb"
	} else if n < (twoPowTen * twoPowTen * twoPowTen) {
		return strconv.Itoa(n/(twoPowTen*twoPowTen)) + " Mb"
	} else {
		return strconv.Itoa(n/(twoPowTen*twoPowTen*twoPowTen)) + " Gb"
	}
}
