package logger

import (
	"fmt"
	"os"
	"sync"

	"a.yandex-team.ru/library/go/core/log"
	arczap "a.yandex-team.ru/library/go/core/log/zap"
)

type Logging struct {
	LogLevel       string
	LogPath        string
	SentryDSN      string
	AppLogFileName string
}

var logger *arczap.Logger
var mutex sync.RWMutex

func Logger() *arczap.Logger {
	mutex.RLock()
	defer mutex.RUnlock()

	return logger
}

func SetLogger(l *arczap.Logger) {
	mutex.Lock()
	defer mutex.Unlock()

	if l == nil {
		return
	}
	if logger != nil {
		_ = logger.L.Sync()
	}
	logger = l
}

func init() {
	aviaLogLevel := os.Getenv("AVIA_LOG_LEVEL")
	if aviaLogLevel == "" {
		aviaLogLevel = "debug"
	}
	level, err := log.ParseLevel(aviaLogLevel)
	if err != nil {
		panic(fmt.Sprintf("can not parse log level %s", aviaLogLevel))
	}

	l, err := arczap.NewDeployLogger(level)
	if err != nil {
		panic(err)
	}

	SetLogger(l)
}
