package strutil

import (
	"strings"
)

func Coalesce(strings ...string) string {
	if len(strings) == 0 {
		return ""
	}
	for _, s := range strings {
		if len(s) > 0 {
			return s
		}
	}
	return ""
}

func EmptyToNil(actual string) *string {
	if actual == "" {
		return nil
	}
	return &actual
}

func RemoveLeadingZeroes(flight string) string {
	return strings.TrimLeft(flight, "0")
}
