package strutil

import "strings"

// Roughly based on ICAO 9303 part 3 paragraph 6.B
var ru2enIcao9303 = map[string]string{
	"А": "A", "Б": "B", "В": "V", "Г": "G", "Д": "D", "Е": "E",
	"Ё": "E", "Ж": "ZH", "З": "Z", "И": "I", "Й": "I", "К": "K",
	"Л": "L", "М": "M", "Н": "N", "О": "O", "П": "P", "Р": "R",
	"С": "S", "Т": "T", "У": "U", "Ф": "F", "Х": "KH", "Ц": "TS",
	"Ч": "CH", "Ш": "SH", "Щ": "SHCH", "Ъ": "IE", "Ы": "Y", "Ь": "",
	"Э": "E", "Ю": "IU", "Я": "IA",
}

func init() {
	for k, v := range ru2enIcao9303 {
		ru2enIcao9303[strings.ToLower(k)] = strings.ToLower(v)
	}
}

func EncodeIcao9303(cyr string) string {
	buffer := strings.Builder{}
	for _, ch := range cyr {
		if replacement, found := ru2enIcao9303[string(ch)]; found {
			buffer.WriteString(replacement)
		} else {
			buffer.WriteString(string(ch))
		}
	}
	return buffer.String()
}
