package timeutil

import (
	"time"
)

func Coalesce(times ...time.Time) time.Time {
	if len(times) == 0 {
		return time.Time{}
	}
	for _, t := range times {
		if !t.IsZero() {
			return t
		}
	}
	return time.Time{}
}
