# coding=utf-8
from __future__ import unicode_literals

from datetime import timedelta


# Build dates index for [-5, +80] years
class DateIndex(object):

    def __init__(self, date):
        self._dates = {}
        self._base_date = date
        self._base_day_of_week = date.weekday()
        start_date = date - timedelta(days=5*366)
        end_date = date + timedelta(days=80*366)
        # fill the part in the past
        cur_date = date
        index = 0
        while cur_date >= start_date:
            self._dates[DateIndex.get_str(cur_date)] = index
            index -= 1
            cur_date = cur_date - timedelta(days=1)

        # fill the part in the future
        cur_date = date
        index = 0
        while cur_date <= end_date:
            self._dates[DateIndex.get_str(cur_date)] = index
            index += 1
            cur_date = cur_date + timedelta(days=1)
        self._start_date = DateIndex.get_int(start_date)
        self._end_date = DateIndex.get_int(end_date)
        self._start_strdate = DateIndex.get_str(start_date)
        self._end_strdate = DateIndex.get_str(end_date)

    def get_index(self, date):
        return self._dates[DateIndex.get_str(date)]

    def get_index_for_date_str(self, date_str):
        return self._dates[date_str.replace('.', '-')]

    def get_date(self, index):
        return self._base_date + timedelta(days=index)

    def get_date_str(self, index):
        return DateIndex.get_str(self.get_date(index))

    def get_date_int(self, index):
        return DateIndex.get_int(self.get_date(index))

    # 1-based
    def get_weekday_by_index(self, index):
        return 1 + (self._base_day_of_week + index) % 7

    # 1-based
    def get_weekday_by_date(self, date):
        return self.get_weekday_by_index(self.get_index(date))

    # 1-based
    def get_weekday_by_date_str(self, date_str):
        return self.get_weekday_by_index(self._dates[date_str])

    # places date into actual range
    def adjust_intdate(self, intdate):
        if intdate <= 1:
            return intdate
        if intdate < self._start_date:
            return self._start_date
        if intdate > self._end_date:
            return self._end_date
        return intdate

    # places date into actual range
    def adjust_strdate(self, strdate):
        if not strdate:
            return strdate
        if strdate < self._start_strdate:
            return self._start_strdate
        if strdate > self._end_strdate:
            return self._end_strdate
        return strdate

    @staticmethod
    def get_str(date):
        return date.strftime('%Y-%m-%d')

    @staticmethod
    def get_int(date):
        return (date.year * 100 + date.month) * 100 + date.day
