# coding=utf-8
from __future__ import unicode_literals


def shift_week_days(week_days, day_shift):
    shifted_days = []
    while week_days > 0:
        week_day = week_days % 10
        week_days = week_days // 10
        shifted_day = ((week_day - 1) % 7 + day_shift) % 7 + 1
        shifted_days.append(shifted_day)
    shifted_days.sort()
    result = 0
    for day in shifted_days:
        result = result * 10 + day
    return result


def get_days_shift(week_days1, week_days2):
    if not week_days1 or not week_days2 or week_days1 == week_days2:
        return 0

    for shift in range(1, 7):
        if shift_week_days(week_days1, shift) == week_days2:
            return shift
    return 0
