from collections import OrderedDict

from six.moves.urllib.parse import urlencode


def conn_string(user, password, database, port, cluster_id=None, hostname=None):
    host_cluster_template = 'c-{cluster_id}.rw.db.yandex.net'
    hosts = hostname or host_cluster_template.format(cluster_id=cluster_id)
    return 'postgresql+psycopg2://{user}:{password}@{hosts}/{database}?{query_string}'.format(
        user=user,
        password=password,
        database=database,
        hosts=hosts,
        query_string=urlencode(OrderedDict((
            ('port', port),
            ('sslmode', 'require'),
            ('target_session_attrs', 'read-write'),
        ))),
    )
