# coding: utf8
from __future__ import unicode_literals

import json
import traceback
from datetime import date, datetime

from sqlalchemy.ext.declarative import DeclarativeMeta, declarative_base

from sqlalchemy_continuum import make_versioned

Base = declarative_base()
make_versioned(user_cls=None)


# Only for logging purposes, do not use for storing/retrieving objects anywhere
class CustomEncoder(json.JSONEncoder):

    def default(self, obj):
        try:
            if isinstance(obj.__class__, DeclarativeMeta):
                fields = {}
                for field in [x for x in dir(obj) if not x.startswith('_') and x != 'metadata']:
                    data = obj.__getattribute__(field)
                    if isinstance(data, datetime) or isinstance(data, date):
                        data = data.isoformat()
                    try:
                        json.dumps(data)
                        fields[field] = data
                    except TypeError:
                        fields[field] = None
                return fields

            return json.JSONEncoder.default(self, obj)
        except:
            return traceback.format_exc()
