# coding: utf8
from __future__ import absolute_import, unicode_literals

from sqlalchemy import Boolean, Column, Integer, String

from travel.avia.shared_flights.lib.python.db_models.base import Base


class Carrier(Base):
    __tablename__ = 'carrier'

    id = Column(Integer, primary_key=True, autoincrement=False)
    address = Column(String, nullable=True)
    home_station_id = Column(Integer, nullable=True)
    iata = Column(String, nullable=True)
    icao = Column(String, nullable=True)
    title = Column(String, nullable=True)
    title_en = Column(String, nullable=True)
    url = Column(String, nullable=True)
    contact_info = Column(String, nullable=True)
    description = Column(String, nullable=True)
    logo = Column(String, nullable=True)
    country_id = Column(Integer, nullable=True)
    transport_type = Column(Integer, nullable=True)
    is_hidden = Column(Boolean, nullable=True)
    is_strange = Column(Boolean, nullable=True)
    email = Column(String, nullable=True)
    sirena_id = Column(String, nullable=True)
    phone = Column(String, nullable=True)
    phone_booking = Column(String, nullable=True)
    meta_title = Column(String, nullable=True)
    meta_description = Column(String, nullable=True)
    supplier_code = Column(String, nullable=True)
    title_ru = Column(String, nullable=True)
    title_uk = Column(String, nullable=True)
    title_tr = Column(String, nullable=True)
    short_title = Column(String, nullable=True)
    short_title_ru = Column(String, nullable=True)
    short_title_en = Column(String, nullable=True)
    short_title_uk = Column(String, nullable=True)
    short_title_tr = Column(String, nullable=True)
    is_freight = Column(Boolean, nullable=True)
    icon = Column(String, nullable=True)
    logo_mono = Column(String, nullable=True)
    logo_bg_color = Column(String, nullable=True)
    priority = Column(Integer, nullable=True)
    icao_ru = Column(String, nullable=True)
    svg_logo = Column(String, nullable=True)
    alliance_id = Column(Integer, nullable=True)
    bonus_name = Column(String, nullable=True)
    bonus_name_ru = Column(String, nullable=True)
    bonus_name_en = Column(String, nullable=True)
    bonus_name_tr = Column(String, nullable=True)
    bonus_name_uk = Column(String, nullable=True)
    svg2png_logo = Column(String, nullable=True)
    registration_phone = Column(String, nullable=True)
    registration_phone_ru = Column(String, nullable=True)
    registration_phone_en = Column(String, nullable=True)
    registration_phone_tr = Column(String, nullable=True)
    registration_phone_uk = Column(String, nullable=True)
    registration_url = Column(String, nullable=True)
    registration_url_ru = Column(String, nullable=True)
    registration_url_en = Column(String, nullable=True)
    registration_url_tr = Column(String, nullable=True)
    registration_url_uk = Column(String, nullable=True)
    tis_code = Column(String, nullable=True)
    express_code = Column(String, nullable=True)
    yandex_avia_code = Column(String, nullable=True)

    def merge(self, proto):
        if proto.Id != self.id:
            raise ValueError('Trying to merge carriers with different ids: {} != {}'.format(proto.Id, self.id))

        self.address = proto.Address
        self.home_station_id = proto.HomeStationId
        self.iata = proto.Iata
        self.icao = proto.Icao
        self.title = proto.Title
        self.title_en = proto.TitleEn
        self.url = proto.Url
        self.contact_info = proto.ContactInfo
        self.description = proto.Description
        self.logo = proto.Logo
        self.country_id = proto.CountryId
        self.transport_type = proto.TransportType
        self.is_hidden = proto.IsHidden
        self.is_strange = proto.IsStrange
        self.email = proto.Email
        self.sirena_id = proto.SirenaId
        self.phone = proto.Phone
        self.phone_booking = proto.PhoneBooking
        self.meta_title = proto.MetaTitle
        self.meta_description = proto.MetaDescription
        self.supplier_code = proto.SupplierCode
        self.title_ru = proto.TitleRu
        self.title_uk = proto.TitleUk
        self.title_tr = proto.TitleTr
        self.short_title = proto.ShortTitle
        self.short_title_ru = proto.ShortTitleRu
        self.short_title_en = proto.ShortTitleEn
        self.short_title_uk = proto.ShortTitleUk
        self.short_title_tr = proto.ShortTitleTr
        self.is_freight = proto.IsFreight
        self.icon = proto.Icon
        self.logo_mono = proto.LogoMono
        self.logo_bg_color = proto.LogoBgColor
        self.priority = proto.Priority
        self.icao_ru = proto.IcaoRu
        self.svg_logo = proto.SvgLogo
        self.alliance_id = proto.AllianceId
        self.bonus_name = proto.BonusName
        self.bonus_name_ru = proto.BonusNameRu
        self.bonus_name_en = proto.BonusNameEn
        self.bonus_name_tr = proto.BonusNameTr
        self.bonus_name_uk = proto.BonusNameUk
        self.svg2png_logo = proto.Svg2PngLogo
        self.registration_phone = proto.RegistrationPhone
        self.registration_phone_ru = proto.RegistrationPhoneRu
        self.registration_phone_en = proto.RegistrationPhoneEn
        self.registration_phone_tr = proto.RegistrationPhoneTr
        self.registration_phone_uk = proto.RegistrationPhoneUk
        self.registration_url = proto.RegistrationUrl
        self.registration_url_ru = proto.RegistrationUrlRu
        self.registration_url_en = proto.RegistrationUrlEn
        self.registration_url_tr = proto.RegistrationUrlTr
        self.registration_url_uk = proto.RegistrationUrlUk
        self.tis_code = proto.TisCode
        self.express_code = proto.ExpressCode
        self.yandex_avia_code = proto.YandexAviaCode

    def __unicode__(self):
        return ' '.join(map(str, [
            self.iata or self.icao or self.icao_ru,
            self.title or self.title_ru or self.title_en or
            self.meta_title or
            self.short_title or self.short_title_en or self.short_title_ru,
        ]))

    def __str__(self):
        return self.__unicode__()

    def __repr__(self):
        return self.__class__.__name__ + ' <' + ', '.join(['='.join([k, v]) for k, v in self.__dict__]) + '>'
