# coding: utf8
from __future__ import unicode_literals, absolute_import

from enum import Enum
from sqlalchemy import Column, DateTime, String

from travel.avia.shared_flights.lib.python.db_models.base import Base


class DbLockType(Enum):
    DBLOCK_IMPORT_SIRENA = 'IMPORT_SIRENA'
    DBLOCK_IMPORT_AMADEUS = 'IMPORT_AMADEUS'
    DBLOCK_IMPORT_STOP_POINTS = 'IMPORT_STOP_POINTS'
    DBLOCK_IMPORT_TRANSPORT_MODELS = 'IMPORT_TRANSPORT_MODELS'
    DBLOCK_BUILD_DIFF_PIVOT = 'BUILD_DIFF_PIVOT'
    DBLOCK_BUILD_SNAPSHOT = 'BUILD_SNAPSHOT'
    DBLOCK_BUILD_DELTA = 'BUILD_DELTA'


class DbLock(Base):

    __tablename__ = 'db_lock'

    lock_type = Column(String, primary_key=True)
    lock_token = Column(String, nullable=False)

    created_at = Column(DateTime, nullable=False)
    expires_at = Column(DateTime, nullable=False)
    updated_at = Column(DateTime, nullable=False)
