# coding: utf8
from __future__ import absolute_import, unicode_literals

from sqlalchemy import Column, Integer, String

from travel.avia.shared_flights.lib.python.db_models.base import Base


class DesignatedCarrier(Base):
    __tablename__ = 'designated_carrier'

    id = Column(Integer, primary_key=True, autoincrement=False)
    title = Column(String, nullable=False)

    def merge(self, proto):
        self.id = proto.Id
        self.title = proto.Title

    def __unicode__(self):
        return self.__repr__()

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return '{}, {}'.format(self.id, self.title)
