# coding: utf8
from __future__ import unicode_literals, absolute_import

from sqlalchemy import BigInteger, Column, DateTime, Integer, String

from travel.avia.shared_flights.lib.python.db_models.base import Base


class ExistingFlightBase(Base):
    __tablename__ = 'existing_flight_base'

    id = Column(Integer, primary_key=True, autoincrement=False)

    operating_carrier = Column(BigInteger, nullable=False)
    operating_carrier_iata = Column(String, nullable=True)
    operating_flight_number = Column(String, nullable=False)
    leg_seq_number = Column(Integer, nullable=False)
    departure_station = Column(BigInteger, nullable=False)
    departure_station_iata = Column(String, nullable=True)
    scheduled_departure_time = Column(Integer, nullable=False)
    departure_terminal = Column(String, nullable=True)
    arrival_station = Column(BigInteger, nullable=False)
    arrival_station_iata = Column(String, nullable=True)
    scheduled_arrival_time = Column(Integer, nullable=False)
    arrival_terminal = Column(String, nullable=True)

    aircraft_model = Column(String, nullable=True)
    flying_carrier_iata = Column(String, nullable=True)
    intl_dom_status = Column(String, nullable=True)
    traffic_restriction_code = Column(String, nullable=True)
    designated_carrier = Column(Integer, nullable=True)

    created_at = Column(DateTime, nullable=False)
    source = Column(Integer, primary_key=True, nullable=False)

    def to_dict(self):
        return {
            'id': self.id,
            'operating_carrier': self.operating_carrier,
            'operating_carrier_iata': self.operating_carrier_iata,
            'operating_flight_number': self.operating_flight_number,
            'leg_seq_number': self.leg_seq_number,
            'departure_station': self.departure_station,
            'departure_station_iata': self.departure_station_iata,
            'scheduled_departure_time': self.scheduled_departure_time,
            'departure_terminal': self.departure_terminal,
            'arrival_station': self.arrival_station,
            'arrival_station_iata': self.arrival_station_iata,
            'scheduled_arrival_time': self.scheduled_arrival_time,
            'arrival_terminal': self.arrival_terminal,
            'aircraft_model': self.aircraft_model,
            'flying_carrier_iata': self.flying_carrier_iata,
            'intl_dom_status': self.intl_dom_status,
            'traffic_restriction_code': self.traffic_restriction_code,
            'designated_carrier': self.designated_carrier,
            'source': self.source,
            'created_at': self.created_at,
        }
