# coding: utf8
from __future__ import unicode_literals, absolute_import

from sqlalchemy import BigInteger, Boolean, Column, Date, DateTime, Integer, String

from travel.avia.shared_flights.lib.python.db_models.base import Base


class ExistingFlightPattern(Base):

    __tablename__ = 'existing_flight_pattern'

    flight_departure_day = Column(Date, primary_key=True, nullable=False)
    marketing_carrier = Column(BigInteger, primary_key=True, nullable=False)
    marketing_flight_number = Column(String, primary_key=True, nullable=False)
    leg_seq_number = Column(Integer, primary_key=True, nullable=False)
    source = Column(Integer, primary_key=True, nullable=False)

    flight_base_id = Column(Integer, nullable=False)
    marketing_carrier_iata = Column(String, nullable=True)

    is_administrative = Column(Boolean, nullable=False)
    is_codeshare = Column(Boolean, nullable=False)
    arrival_day_shift = Column(Integer, nullable=False)
    designated_carrier = Column(Integer, nullable=True, default=0, server_default='0')
    departure_day_shift = Column(Integer, nullable=False, default=0, server_default='0')
    is_derivative = Column(Boolean, nullable=False, default=False)

    created_at = Column(DateTime, nullable=False)

    def to_dict(self):
        return {
            'flight_departure_day': self.flight_departure_day,
            'marketing_carrier': self.marketing_carrier,
            'marketing_flight_number': self.marketing_flight_number,
            'leg_seq_number': self.leg_seq_number,
            'source': self.source,
            'flight_base_id': self.flight_base_id,
            'marketing_carrier_iata': self.marketing_carrier_iata,
            'is_administrative': self.is_administrative,
            'is_codeshare': self.is_codeshare,
            'arrival_day_shift': self.arrival_day_shift,
            'designated_carrier': self.designated_carrier,
            'departure_day_shift': self.departure_day_shift,
            'is_derivative': self.is_derivative,
            'created_at': self.created_at,
        }
