# coding: utf8
from __future__ import unicode_literals, absolute_import

from sqlalchemy import BigInteger, Column, Integer, String

from travel.avia.shared_flights.lib.python.db_models.base import Base


class FlightBaseMixin(object):
    id = Column(Integer, primary_key=True, autoincrement=False)

    bucket_key = Column(String, nullable=False)
    operating_carrier = Column(BigInteger, nullable=False)
    operating_carrier_iata = Column(String, nullable=True)
    operating_flight_number = Column(String, nullable=False)
    itinerary_variation = Column(String, nullable=False)
    leg_seq_number = Column(Integer, nullable=False)
    departure_station = Column(BigInteger, nullable=False)
    departure_station_iata = Column(String, nullable=True)
    scheduled_departure_time = Column(Integer, nullable=False)
    local_dep_utc_time_var = Column(Integer, nullable=False)
    departure_terminal = Column(String, nullable=True)
    arrival_station = Column(BigInteger, nullable=False)
    arrival_station_iata = Column(String, nullable=True)
    scheduled_arrival_time = Column(Integer, nullable=False)
    local_arr_utc_time_var = Column(Integer, nullable=False)
    arrival_terminal = Column(String, nullable=True)

    aircraft_model = Column(String, nullable=True)
    flying_carrier_iata = Column(String, nullable=True)
    intl_dom_status = Column(String, nullable=True)
    traffic_restriction_code = Column(String, nullable=True)
    designated_carrier = Column(Integer, nullable=True)


class FlightBase(FlightBaseMixin, Base):
    __tablename__ = 'flight_base'


class SirenaFlightBase(FlightBaseMixin, Base):
    __tablename__ = 'sirena_flight_base'


class ApmFlightBase(FlightBaseMixin, Base):
    __tablename__ = 'apm_flight_base'
