# coding: utf8
from __future__ import absolute_import, unicode_literals

import datetime
import sqlalchemy as sa
import sqlalchemy.orm as sorm

from travel.avia.shared_flights.lib.python.db_models.base import Base
from travel.avia.shared_flights.lib.python.db_models.carrier import Carrier


class FlightMergeRule(Base):
    __tablename__ = 'flight_merge_rule'

    id = sa.Column(sa.Integer, primary_key=True, autoincrement=True)

    operating_carrier_id = sa.Column(sa.Integer, sa.ForeignKey(Carrier.id))
    operating_carrier = sorm.relationship(
        Carrier, foreign_keys=[operating_carrier_id],
    )
    operating_flight_number_regex = sa.Column(sa.String, nullable=True)

    marketing_carrier_id = sa.Column(sa.Integer, sa.ForeignKey(Carrier.id))
    marketing_carrier = sorm.relationship(
        Carrier, foreign_keys=[marketing_carrier_id],
    )
    marketing_flight_number_regex = sa.Column(sa.String, nullable=True)
    excluded_carrier_id = sa.Column(sa.Integer, sa.ForeignKey(Carrier.id))
    excluded_carrier = sorm.relationship(
        Carrier, foreign_keys=[excluded_carrier_id],
    )

    should_merge = sa.Column(sa.Boolean, nullable=False, default=True)
    is_rule_active = sa.Column(sa.Boolean, nullable=False, default=True)

    updated_at = sa.Column(sa.DateTime, onupdate=datetime.datetime.utcnow, nullable=True, default=datetime.datetime.utcnow)
    comment = sa.Column(sa.String, nullable=False)
