# coding: utf8
from __future__ import unicode_literals, absolute_import

from sqlalchemy import BigInteger, Boolean, Column, Date, Integer, String, Index

from travel.avia.shared_flights.lib.python.db_models.base import Base


class FlightPatternMixin(object):
    id = Column(Integer, primary_key=True, autoincrement=False)

    bucket_key = Column(String, nullable=False)
    flight_base_id = Column(Integer, nullable=False)
    flight_leg_key = Column(String, nullable=False)
    operating_from = Column(Date, nullable=False)
    operating_until = Column(Date, nullable=False)
    operating_on_days = Column(Integer, nullable=False)
    marketing_carrier = Column(BigInteger, nullable=False)
    marketing_carrier_iata = Column(String, nullable=True)
    marketing_flight_number = Column(String, nullable=False)

    is_administrative = Column(Boolean, nullable=False)
    is_codeshare = Column(Boolean, nullable=False)
    performance = Column(Integer, nullable=False)
    arrival_day_shift = Column(Integer, nullable=False)
    operating_flight_pattern_id = Column(Integer, nullable=False, default=0, server_default='0')
    leg_seq_number = Column(Integer, nullable=False, default=0, server_default='0')
    designated_carrier = Column(Integer, nullable=True, default=0, server_default='0')
    departure_day_shift = Column(Integer, nullable=False, default=0, server_default='0')
    is_derivative = Column(Boolean, nullable=False, default=False)


class FlightPattern(FlightPatternMixin, Base):
    __tablename__ = 'flight_pattern'
    __table_args__ = (
        Index(str(__tablename__) + '_carrier_flight_number_index',
              'marketing_carrier', 'marketing_flight_number'),
        Index(str(__tablename__) + '_carrier_flight_number_index_fr_un',
              'marketing_carrier', 'marketing_flight_number', 'operating_from', 'operating_until'),
        Index(str(__tablename__) + '_carrier_iata_flight_number_index_fr_un',
              'marketing_carrier_iata', 'marketing_flight_number', 'operating_from', 'operating_until'),
    )


class SirenaFlightPattern(FlightPatternMixin, Base):
    __tablename__ = 'sirena_flight_pattern'
    __table_args__ = (
        Index(str(__tablename__) + '_carrier_flight_number_index',
              'marketing_carrier', 'marketing_flight_number'),
        Index(str(__tablename__) + '_carrier_flight_number_index_fr_un',
              'marketing_carrier', 'marketing_flight_number', 'operating_from', 'operating_until'),
        Index(str(__tablename__) + '_carrier_iata_flight_number_index_fr_un',
              'marketing_carrier_iata', 'marketing_flight_number', 'operating_from', 'operating_until'),
    )


class ApmFlightPattern(FlightPatternMixin, Base):
    __tablename__ = 'apm_flight_pattern'
    __table_args__ = (
        Index(str(__tablename__) + '_carrier_flight_number_index',
              'marketing_carrier', 'marketing_flight_number'),
        Index(str(__tablename__) + '_carrier_flight_number_index_fr_un',
              'marketing_carrier', 'marketing_flight_number', 'operating_from', 'operating_until'),
        Index(str(__tablename__) + '_carrier_iata_flight_number_index_fr_un',
              'marketing_carrier_iata', 'marketing_flight_number', 'operating_from', 'operating_until'),
    )
