# coding: utf8
from __future__ import unicode_literals, absolute_import

from sqlalchemy import BigInteger, Boolean, Column, Date, DateTime, Integer, String

from travel.avia.shared_flights.lib.python.db_models.base import Base


class FlightPatternOverrideMixin(object):
    id = Column(Integer, primary_key=True, autoincrement=False)

    bucket_key = Column(String, nullable=False)
    flight_base_id = Column(Integer, nullable=False)
    leg_number = Column(Integer, nullable=False)
    operating_from = Column(Date, nullable=False)
    operating_until = Column(Date, nullable=False)
    operating_on_days = Column(Integer, nullable=False)
    marketing_carrier = Column(BigInteger, nullable=False)
    marketing_carrier_iata = Column(String, nullable=True)
    marketing_flight_number = Column(String, nullable=False)

    is_administrative = Column(Boolean, nullable=False)
    is_codeshare = Column(Boolean, nullable=False)
    performance = Column(Integer, nullable=False)
    overrides = Column(String, nullable=True)

    created_at = Column(DateTime, nullable=True)
    updated_at = Column(DateTime, nullable=True)


class FlightPatternCorrection(FlightPatternOverrideMixin, Base):
    __tablename__ = 'flight_pattern_correction'
