# coding: utf8
from __future__ import absolute_import, unicode_literals

import sqlalchemy as sa
import sqlalchemy.orm as sorm

from travel.avia.shared_flights.lib.python.db_models.base import Base
from travel.avia.shared_flights.lib.python.db_models.flight_status_source import FlightStatusSource


class FlightStatus(Base):
    __tablename__ = 'flight_status'

    __table_args__ = (
        sa.PrimaryKeyConstraint(
            'airlinecode', 'flightnumber', 'legnumber', 'flightdate', 'statussourceid',
        ),
    )

    airlineid = sa.Column(sa.BigInteger, nullable=False)
    airlinecode = sa.Column(sa.String, nullable=False, default='', server_default='')
    flightnumber = sa.Column(sa.String, nullable=False)
    legnumber = sa.Column(sa.SmallInteger, nullable=False)
    flightdate = sa.Column(sa.Date, nullable=False)
    statussourceid = sa.Column(sa.SmallInteger, sa.ForeignKey(FlightStatusSource.id), nullable=False)
    statussource = sorm.relationship(FlightStatusSource, foreign_keys=[statussourceid])
    routepointfrom = sa.Column(sa.String, nullable=False, default='', server_default='')
    routepointto = sa.Column(sa.String, nullable=False, default='', server_default='')
    createdatutc = sa.Column(sa.DateTime, nullable=True)
    updatedatutc = sa.Column(sa.DateTime, nullable=True)
    departureairport = sa.Column(sa.String, nullable=True)
    departurestatus = sa.Column(sa.String, nullable=True)
    departuregate = sa.Column(sa.String, nullable=True)
    departureterminal = sa.Column(sa.String, nullable=True)
    departurediverted = sa.Column(sa.Boolean, nullable=True)
    departuredivertedairportcode = sa.Column(sa.String, nullable=True)
    departurecreatedatutc = sa.Column(sa.DateTime, nullable=True)
    departurereceivedatutc = sa.Column(sa.DateTime, nullable=True)
    departureupdatedatutc = sa.Column(sa.DateTime, nullable=True)
    arrivalairport = sa.Column(sa.String, nullable=True)
    arrivalstatus = sa.Column(sa.String, nullable=True)
    arrivalgate = sa.Column(sa.String, nullable=True)
    arrivalterminal = sa.Column(sa.String, nullable=True)
    arrivaldiverted = sa.Column(sa.Boolean, nullable=True)
    arrivaldivertedairportcode = sa.Column(sa.String, nullable=True)
    arrivalcreatedatutc = sa.Column(sa.DateTime, nullable=True)
    arrivalreceivedatutc = sa.Column(sa.DateTime, nullable=True)
    arrivalupdatedatutc = sa.Column(sa.DateTime, nullable=True)
    checkindesks = sa.Column(sa.String, nullable=True)
    baggagecarousels = sa.Column(sa.String, nullable=True)
    departuretimeactual = sa.Column(sa.DateTime, nullable=True)
    departuretimescheduled = sa.Column(sa.DateTime, nullable=True)
    arrivaltimeactual = sa.Column(sa.DateTime, nullable=True)
    arrivaltimescheduled = sa.Column(sa.DateTime, nullable=True)
    departureroutepointfrom = sa.Column(sa.String, nullable=True)
    departureroutepointto = sa.Column(sa.String, nullable=True)
    arrivalroutepointfrom = sa.Column(sa.String, nullable=True)
    arrivalroutepointto = sa.Column(sa.String, nullable=True)
