# coding: utf8
from __future__ import absolute_import, unicode_literals

import sqlalchemy as sa

from travel.avia.shared_flights.lib.python.db_models.base import Base


class FlightStatusSource(Base):
    __tablename__ = 'status_source'

    id = sa.Column(sa.SmallInteger, primary_key=True, autoincrement=True)
    name = sa.Column(sa.String, nullable=False, index=True, unique=True)
    priority = sa.Column(sa.SmallInteger, nullable=False, default=0, index=True, unique=True)

    def __unicode__(self):
        return self.__repr__()

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return '(%s) %s [%s]' % (str(self.id), str(self.name), str(self.priority))
