# coding: utf8
from __future__ import absolute_import, unicode_literals

from sqlalchemy import Column, String

from travel.avia.shared_flights.lib.python.db_models.base import Base

'''
Cмысл этого справочника - в вычислении flying carrier для рейсов, полученных из Сирены.
т.к. в данных Сирены указывается только marketing carrier.
Соответственно, кодшеры и flying carriers приходится вычислять через SSIM.
Bucket (то же самое, что BucketKey) позволяет мэппить сегменты дешевле и быстрее, чем искать flight-pattern в кеше.
'''


class FlyingCarrier(Base):
    __tablename__ = 'flying_carrier'

    # bucket == "{carrier_id}.{flight_number}.{leg_seq_number}"

    bucket = Column(String, primary_key=True, nullable=False)
    flying_carrier_iata = Column(String, primary_key=True, nullable=False)

    def merge(self, proto):
        self.bucket = proto.Bucket
        self.flying_carrier_iata = proto.FlyingCarrierIata

    def __unicode__(self):
        return self.__repr__()

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return '{}, {}'.format(self.bucket, self.flying_carrier_iata)

    @staticmethod
    def to_dict(flying_carrier_proto):
        return {
            'bucket': flying_carrier_proto.Bucket,
            'flying_carrier_iata': flying_carrier_proto.FlyingCarrierIata,
        }
