# coding: utf8
from __future__ import absolute_import, unicode_literals

from datetime import datetime
import sqlalchemy as sa

from travel.avia.shared_flights.lib.python.db_models.base import Base


class IataCorrectionRule(Base):
    __versioned__ = {}
    __tablename__ = 'iata_correction'

    id = sa.Column(sa.Integer, primary_key=True, autoincrement=True)
    marketing_carrier_iata = sa.Column(sa.String, nullable=True)
    carrier_sirena = sa.Column(sa.String, nullable=True)
    flying_carrier_iata = sa.Column(sa.String, nullable=True)
    designated_carrier = sa.Column(sa.String, nullable=True)
    flight_number_regex = sa.Column(sa.String, nullable=True)
    carrier_id = sa.Column(sa.Integer, nullable=False)
    priority = sa.Column(sa.Integer, nullable=False, default=0)

    created_at = sa.Column(sa.DateTime, server_default=sa.func.now(), default=datetime.utcnow, nullable=False)
    updated_at = sa.Column(sa.DateTime, default=datetime.utcnow, onupdate=datetime.utcnow, nullable=True)

    @staticmethod
    def get_priority(rule):
        return rule.priority if rule.priority else 0
