# coding: utf8
from __future__ import unicode_literals, absolute_import

from sqlalchemy import BigInteger, Column, Integer, DateTime, String

from travel.avia.shared_flights.lib.python.db_models.base import Base


class LastImportedInfo(Base):

    __tablename__ = 'last_imported_info'

    id = Column(Integer, primary_key=True)

    imported_date = Column(DateTime, nullable=False)
    imported_resource_id = Column(BigInteger, nullable=False)
    # Resource types are listed here:
    # https://a.yandex-team.ru/arc/trunk/arcadia/travel/avia/shared_flights/data_importer/flights_data_importer.py?rev=6146217#L113
    resource_type = Column(String, nullable=False)

    created_at = Column(DateTime, nullable=False)
    updated_at = Column(DateTime, nullable=False)
