# coding: utf8
from __future__ import absolute_import, unicode_literals

from sqlalchemy import Boolean, Column, Float, Integer, String

from travel.avia.shared_flights.lib.python.db_models.base import Base


class Station(Base):
    __tablename__ = 'station_with_codes'

    id = Column(Integer, primary_key=True, autoincrement=False)
    settlement_id = Column(Integer, nullable=True)
    majority = Column(Integer, nullable=True)
    time_zone_id = Column(Integer, nullable=True)
    popular_title_default = Column(String, nullable=True)
    popular_title_ru_nominative_case = Column(String, nullable=True)
    popular_title_ru_genitive_case = Column(String, nullable=True)
    popular_title_uk_nominative_case = Column(String, nullable=True)
    title_default = Column(String, nullable=True)
    title_ru_nominative_case = Column(String, nullable=True)
    title_ru_genitive_case = Column(String, nullable=True)
    title_ru_accusative_case = Column(String, nullable=True)
    title_ru_prepositional_case = Column(String, nullable=True)
    title_ru_preposition = Column(String, nullable=True)
    title_uk_nominative_case = Column(String, nullable=True)
    is_hidden = Column(Boolean, nullable=True)
    longitude = Column(Float, nullable=True)
    latitude = Column(Float, nullable=True)
    stype = Column(Integer, nullable=True)
    ttype = Column(Integer, nullable=True)
    railway_time_zone_id = Column(Integer, nullable=True)
    region_id = Column(Integer, nullable=True)
    district_id = Column(Integer, nullable=True)
    country_id = Column(Integer, nullable=True)
    iata = Column(String, nullable=True)
    icao = Column(String, nullable=True)
    sirena = Column(String, nullable=True)

    def merge(self, proto):
        if proto.Station.Id != self.id:
            raise ValueError('Trying to merge stations with different ids: {} != {}'.format(proto.Station.Id, self.id))

        self.settlement_id = proto.Station.SettlementId
        self.majority = proto.Station.Majority
        self.time_zone_id = proto.Station.TimeZoneId
        self.popular_title_default = proto.Station.PopularTitleDefault
        self.popular_title_ru_nominative_case = proto.Station.PopularTitleRuNominativeCase
        self.popular_title_ru_genitive_case = proto.Station.PopularTitleRuGenitiveCase
        self.popular_title_uk_nominative_case = proto.Station.PopularTitleUkNominativeCase
        self.title_default = proto.Station.TitleDefault
        self.title_ru_nominative_case = proto.Station.TitleRuNominativeCase
        self.title_ru_genitive_case = proto.Station.TitleRuGenitiveCase
        self.title_ru_accusative_case = proto.Station.TitleRuAccusativeCase
        self.title_ru_prepositional_case = proto.Station.TitleRuPrepositionalCase
        self.title_ru_preposition = proto.Station.TitleRuPreposition
        self.title_uk_nominative_case = proto.Station.TitleUkNominativeCase
        self.is_hidden = proto.Station.IsHidden
        self.longitude = proto.Station.Longitude
        self.latitude = proto.Station.Latitude
        self.stype = proto.Station.Type
        self.ttype = proto.Station.TransportType
        self.railway_time_zone_id = proto.Station.RailwayTimeZoneId
        self.region_id = proto.Station.RegionId
        self.district_id = proto.Station.DistrictId
        self.country_id = proto.Station.CountryId
        self.iata = proto.IataCode
        self.icao = proto.IcaoCode
        self.sirena = proto.SirenaCode

    def __unicode__(self):
        return self.__repr__()

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return self.title_default or self.popular_title_default or self.title_ru_nominative_case or self.popular_title_ru_nominative_case
