# coding: utf8
from __future__ import absolute_import, unicode_literals

import sqlalchemy.orm as sorm
from sqlalchemy import Boolean, Column, Integer, ForeignKey
from travel.avia.shared_flights.lib.python.db_models.base import Base
from travel.avia.shared_flights.lib.python.db_models.flight_status_source import FlightStatusSource
from travel.avia.shared_flights.lib.python.db_models.station import Station


class StationStatusSource(Base):
    __versioned__ = {}
    __tablename__ = 'station_status_source'

    station_id = Column(Integer, ForeignKey(Station.id), primary_key=True, autoincrement=False)
    station = sorm.relationship(
        Station, foreign_keys=[station_id],
    )

    status_source_id = Column(Integer, ForeignKey(FlightStatusSource.id), primary_key=True, autoincrement=False, )
    status_source = sorm.relationship(
        FlightStatusSource, foreign_keys=[status_source_id],
    )

    whitelist = Column(Boolean, nullable=False, default=False)
    blacklist = Column(Boolean, nullable=False, default=False)

    trusted = Column(Boolean, nullable=False, default=False)

    def __unicode__(self):
        return self.__repr__()

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return '%s-%s' % (str(self.station_id), str(self.status_source_id))
