# coding: utf8
from __future__ import absolute_import, unicode_literals

import sqlalchemy.orm as sorm
from datetime import datetime
from sqlalchemy import Column, DateTime, ForeignKey, Integer, String

from travel.avia.shared_flights.lib.python.db_models.base import Base
from travel.avia.shared_flights.lib.python.db_models.station import Station


class StopPoint(Base):
    __tablename__ = 'stop_point'

    id = Column(Integer, primary_key=True, autoincrement=True)
    station_code = Column(String, nullable=True)
    station_id = Column(Integer, ForeignKey(Station.id), nullable=True, default=-1)
    city_code = Column(String, nullable=True)
    leg_key = Column(String, nullable=True)
    unknown_since = Column(DateTime, nullable=False)

    station = sorm.relationship(
        Station, foreign_keys=[station_id],
    )

    def merge(self, proto, leg_key):
        self.station_code = proto.StationCode
        self.city_code = proto.CityCode
        self.leg_key = leg_key
        self.unknown_since = datetime.now()

    def __unicode__(self):
        return self.__repr__()

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return self.station_code or self.city_code
