# coding: utf8
from __future__ import absolute_import, unicode_literals

from sqlalchemy import Boolean, Column, Integer, String

from travel.avia.shared_flights.lib.python.db_models.base import Base


class TransportModel(Base):
    __tablename__ = 'transport_model'

    id = Column(Integer, primary_key=True, autoincrement=False)
    title = Column(String, nullable=True)
    title_en = Column(String, nullable=True)
    code = Column(String, nullable=True)
    code_en = Column(String, nullable=True)
    cargo = Column(Boolean, nullable=True)
    transport_subtype_id = Column(Integer, nullable=True, default=0)
    propeller_flight = Column(Boolean, nullable=True)
    plane_body_type = Column(String, nullable=True)

    def merge(self, proto):
        if proto.Id != self.id:
            raise ValueError('Trying to merge transport models with different ids: {} != {}'.format(proto.Id, self.id))

        self.title = proto.Title
        self.title_en = proto.TitleEn
        self.code = proto.Code
        self.code_en = proto.CodeEn
        self.cargo = proto.Cargo
        self.transport_subtype_id = proto.TransportSubtypeId
        self.propeller_flight = proto.PropellerFlight
        self.plane_body_type = proto.PlaneBodyType

    def __unicode__(self):
        return self.__repr__()

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return self.__class__.__name__ + ' <' + ', '.join(['='.join([k, v]) for k, v in self.__dict__]) + '>'
