package main

import (
	"sync"

	arczap "a.yandex-team.ru/library/go/core/log/zap"
	aviaLogging "a.yandex-team.ru/travel/avia/library/go/logging"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/settings"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/shutdown"
	"a.yandex-team.ru/travel/avia/shared_flights/status_importer/internal/storage"
)

func main() {
	shutdownEventDispatcher := shutdown.EventDispatcher{}
	c := settings.Config{}
	c = c.LoadFromEnv()

	l := configureLogging(&c.Logging)
	if l != nil {
		defer l.L.Sync()
	}
	configureMetrics()

	s := storage.New(c)
	wg := sync.WaitGroup{}
	wg.Add(2)
	go func() {
		defer wg.Done()
		s.RunLogbrokerStatusHandler(&shutdownEventDispatcher)
	}()
	go func() {
		defer wg.Done()
		s.RunServer(&shutdownEventDispatcher)
	}()
	wg.Wait()
}

func configureLogging(cfg *settings.Logging) *arczap.Logger {
	converted, err := cfg.ToLoggerConfig()
	if err != nil {
		panic(err)
	}
	newLogger, err := aviaLogging.NewLogger(converted)
	if err != nil {
		panic(err)
	}
	logger.SetLogger(newLogger)
	return newLogger
}
