package main

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
	"a.yandex-team.ru/travel/library/go/metrics"
	metricsserver "a.yandex-team.ru/travel/library/go/metrics/server"
	"context"
)

func configureMetrics() {
	appMetricsRegistry := metrics.NewRegistryWithDeployTags().WithPrefix("status_importer")

	appMetrics := metrics.NewAppMetrics(appMetricsRegistry)
	metrics.SetGlobalAppMetrics(appMetrics)

	go func() {
		l := logger.Logger().AddCallerSkip(1)
		err := metricsserver.RunMetricsHTTPServer(context.Background(), metricsserver.DefaultMetricsConfig, l, appMetricsRegistry)
		if err != nil {
			logger.Logger().Fatal("Error while starting metrics server", log.Error(err))
		}
	}()
}
